import pandas as pd
import pickle
from decision_company import read_csv_file, create_dataframe, df_copy, concatenate_objects

atp_tennis = read_csv_file('atp_tennis.csv')

# Create a new DataFrame with separate rows for each player
player_data = create_dataframe(['Player', 'Rank', 'Win_Loss_Ratio', 'Surface'])

# Add Player_1 data to the new DataFrame
player_data_1 = df_copy(atp_tennis[['Player_1', 'Rank_1', 'Win_Loss_Ratio_1', 'Surface']])
player_data_1.columns = ['Player', 'Rank', 'Win_Loss_Ratio', 'Surface']

# Add Player_2 data to the new DataFrame
player_data_2 = df_copy(atp_tennis[['Player_2', 'Rank_2', 'Win_Loss_Ratio_2', 'Surface']])
player_data_2.columns = ['Player', 'Rank', 'Win_Loss_Ratio', 'Surface']

# Concatenate Player_1 and Player_2 data
player_data = concatenate_objects(player_data_1, player_data_2, ignore_index=True)

print(player_data)
pickle.dump(player_data,open("./ref_result/player_data.pkl","wb"))